-- 1. Install the PL/PYTHON package on your DB server (for linux servers: sudo apt-get install postgresql-plpython-9.1 )
-- This has already been done for you on FME Cloud instances.

-- 2. Activate PostGIS and the language for your database (can skip if this is already enabled)
CREATE EXTENSION postgis;
-- CREATE EXTENSION plpythonu;
-- Or (for Python 3.x)
CREATE EXTENSION plpython3u;

-- 3. Create Table
CREATE TABLE single_pothole
(
  id serial PRIMARY KEY, -- auto-incrementing ID column (will not 'collapse' itself like the Esri ObjectID)
  date DATE,
  name VARCHAR(255),
  size CHAR(10),
  geom GEOMETRY(Geometry,4326) -- LL84
);

-- 4. Create HTTP function
-- A small PL/Python script to send the HTTP request. 

CREATE OR REPLACE FUNCTION public.send_request(url text, message text)
  RETURNS text AS
$BODY$
import urllib, http.client, urllib.parse

parse_object = urllib.parse.urlparse(args[0])
headers = {"Content-type": "application/json", "Accept": "application/json"}
conn = http.client.HTTPConnection(parse_object.netloc)
conn.request("POST", parse_object.path, args[1], headers)

response = conn.getresponse()
return str(response.status) + ' ' + response.reason
$BODY$
  LANGUAGE 'plpython3u';
-- NOTE: If FME Server returns an error, it will show up in the response message

-- 5. Create Trigger Function
-- Function: public.single_function()

-- DROP FUNCTION public.single_function();

CREATE OR REPLACE FUNCTION public.single_function()
  RETURNS trigger AS
$BODY$
DECLARE
	message	text;
  wkt_point text;

BEGIN
  SELECT ST_AsText(new.geom) INTO wkt_point FROM single_pothole;

  IF (TG_OP = 'INSERT') THEN
    message = '{"id" : "'||new.id||'", "action" : "INSERT", "geom" : "'||wkt_point||'"}';

	ELSEIF (TG_OP = 'UPDATE') THEN
		message = '{"id" : "'||new.id||'", "action" : "UPDATE", "geom" : "'||wkt_point||'"}';

	ELSEIF (TG_OP = 'DELETE') THEN
		SELECT ST_AsText(old.geom) INTO wkt_point FROM single_pothole; --replaces wkt_point variable with old row
		message = '{"id" : "'||old.id||'", "action" : "DELETE", "geom" : "'||wkt_point||'"}';

	END IF;

  PERFORM send_request('http://yourFMEServerWebhookURL', message);

	RETURN NULL;

END
$BODY$
  LANGUAGE 'plpgsql';


-- 6. Create Trigger and bind to table
CREATE TRIGGER trg_single_example AFTER INSERT OR UPDATE OR DELETE
ON single_pothole FOR EACH ROW EXECUTE PROCEDURE single_function();
